<?php

declare(strict_types=1);

namespace Shlinkio\Shlink\Core\ShortUrl;

use Shlinkio\Shlink\Core\Exception\ShortUrlNotFoundException;
use Shlinkio\Shlink\Core\Model\BulkDeleteResult;
use Shlinkio\Shlink\Core\ShortUrl\Model\ShortUrlIdentifier;
use Shlinkio\Shlink\Core\Visit\Repository\VisitDeleterRepositoryInterface;
use Shlinkio\Shlink\Rest\Entity\ApiKey;

readonly class ShortUrlVisitsDeleter implements ShortUrlVisitsDeleterInterface
{
    public function __construct(
        private VisitDeleterRepositoryInterface $repository,
        private ShortUrlResolverInterface $resolver,
    ) {
    }

    /**
     * @throws ShortUrlNotFoundException
     */
    public function deleteShortUrlVisits(ShortUrlIdentifier $identifier, ApiKey|null $apiKey = null): BulkDeleteResult
    {
        $shortUrl = $this->resolver->resolveShortUrl($identifier, $apiKey);
        return new BulkDeleteResult($this->repository->deleteShortUrlVisits($shortUrl));
    }
}
